/*
   Ce programme va se connecter à un serveur et lui envoyer l'état d'un bouton.
*/

#include <ESP8266WiFi.h>

// Gestion du bouton
boolean button = HIGH;
boolean lastbutton = HIGH;
int pin = 0;

// Les accès pour se connecter au réseau wifi
const char* ssid = "FABLAB";
const char* password = "FABLABFAB";

// Adresse IP du serveur et création du client
IPAddress server(192, 168, 0, 2);
WiFiClient client ;


void setup() {
  Serial.begin(115200);
  delay(10);

  pinMode(0, INPUT_PULLUP);

  // Connectons nous au réseau
  Serial.println();
  Serial.println();
  Serial.print("Connection au réseau: ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi connecté");
}

void loop() {
  // lecture de l'état actuel du bouton
  button = digitalRead(pin);
  // Si son état a changé
  if (button != lastbutton) {
    // le client se connecte au serveur...
    client.connect(server, 80);
    if (button == HIGH)
    {
      // ... et lui envoie la chaîne de caractère nécessaire
      client.println("off1\r");
      Serial.println("off1");
    }
    else {
      client.println("on1\r");
      Serial.println("on1");
    }
    // on met à jour le dernier état du bouton pour détecter le prochain changement.
    lastbutton = button;
  }
  delay(20);
  client.flush();
}
