/**
 * Servomoteur et position de la souris 
 *  
 * Nous allons nous connecter au port série, puis relever en permanence la position en X de la souris, puis la convertir en l'envoyer à l'arduino.
 */


import processing.serial.*;

Serial myPort;  // Création de l'objet "port série"
int val;        // La donnée envoyée à l'arduino

void setup() 
{
  size(500, 200); //La taille de notre fenêtre
  
  // Connection au port série, le premier de la liste
  // Penser à printArray(Serial.list()); si on ne connait pas le numéro du port de connection
  String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600); // Bien vérifier la vitesse, qui doit être la même que sur l'Arduino
}

void draw() {
  background(0); // Dessin de l'arrière plan en noir
  stroke(255); // Les contours seront ensuite dessinées en blanc
  line(width/2, 0, width/2, height); // On matérialise le milieu de la fenêtre avec une ligne blanche
  int theMouse = (int) map ( mouseX, 0,width, 0,180); // On récupère les coordonées X de la souris, puis on les convertit dans le champ de valeur attendu par les servo
  myPort.write(theMouse); // Et on envoie cette valeur à l'arduino ! 
  println(theMouse); // debug
  delay(100);
}
