/** 
 * Ce programme reçoit des valeurs depuis un Arduino, via le port série.
 * Il les trie, pour savoir si l'info concerne l'axe X ou l'axe Y, 
 * et s'en sert pour déplacer un disque à l'écran.
 */


import processing.serial.*;

Serial myPort;                  // Le port série
int xpos, ypos;		             // Les variables pour positionner le disque

short LF = 10; // "Fin de ligne"

char HEADERX = 'X'; // C'est le caractère que l'on a inséré avant la valeur du X
char HEADERY = 'Y'; // C'est le caractère que l'on a inséré avant la valeur du Y

void setup() {
  size(512, 512);  // Taille de la fenêtre (choisie car les valeurs mesurées par l'arduino sont entre 0 et 1024. 512 correspond à la moitié).
  noStroke();      // Nous ne dessinerons pas de bordure autour de nos formes
  background(0);   // Fond noir

  // Nous plaçons le disque au milieu de la fenêtre
  xpos = width/2;
  ypos = height/2;

  // Nous imprimons la liste des ports série disponibles
  printArray(Serial.list());

  // Puis nous allons choisir le premier du tableau (à adapter suivant votre configuration), avant de nous connecter à 9600 baud (même vitesse que l'Arduino).
  String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600);
}

void draw() {
  background (0);
  fill(255);
  // Nous dessinons le disque
  ellipse(xpos, ypos, 20, 20);
}

void serialEvent(Serial myPort) {
  String message = myPort.readStringUntil(LF); // On lit le message reçu, jusqu'au saut de ligne
  if (message != null)
  {
    print("Message" + message);
    // On découpe le message à chaque virgule, on le stocke dans un tableau
    String [] data = message.split(",");
    
    // Nous analysons le premier caractère reçu
    //Si c'est un X = message reçu pour l'axe X 
    if (data[0].charAt(0) == HEADERX)
    {
      // On convertit la valeur (String -> Int)
      int XRaw = Integer.parseInt(data[1]);
      // On normalise la valeur entre 0 et 512 en la divisant par 2
      xpos = XRaw/2;
    }

    //Si c'est un Y = message reçu pour l'axe Y 
    else if (data[0].charAt(0) == HEADERY)
    {
      // On convertit la valeur (String -> Int)
      int YRaw = Integer.parseInt(data[1]);
      // On normalise la valeur entre 0 et 512
      ypos = YRaw/2;
    }
  }
}
