/*
   Ce programme montre la création d'un serveur http simple.
   le serveur va définir l'état d'une pin digitale suivant les requetes envoyées par deux clients,
   pour changer les couleurs d'une led RVB
*/

#include <ESP8266WiFi.h>

// Les accès pour se connecter au réseau wifi
const char* ssid = "FABLAB";
const char* password = "FABLABFAB";

// On créé un serveur web, en spécifiant le port d'accès en argument
WiFiServer server(80);

void setup() {
  Serial.begin(115200);
  delay(10);

  // Les 3 pins de la LED RVB
  pinMode(2, OUTPUT); //bleu
  pinMode(4, OUTPUT); //rouge
  pinMode(5, OUTPUT); //vert
  digitalWrite(2, LOW);
  digitalWrite(4, LOW);
  digitalWrite(5, LOW);

  // Connectons nous au réseau
  Serial.println();
  Serial.println();
  Serial.print("Connection au réseau: ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi connecté");

  // Puis démarrons le serveur
  server.begin();
  Serial.println("Serveur démarré");

  // Affichage de l'adresse IP
  Serial.println(WiFi.localIP());
}

void loop() {
  // On vérifie qu'un client est connecté
  WiFiClient client = server.available();
  if (!client) {
    return;
  }

  // Puis on attend qu'il envoie des données
  while (!client.available()) {
    delay(1);
    // On lit la première ligne de la requête
    String req = client.readStringUntil('\r');
    Serial.println(req);
    client.println("Vous avez bien été connecté \r");
    // On analyse cette requête
    if (req == "on1")
    {
      digitalWrite(2, HIGH);
    }
    else if (req == "off1")
    {
      digitalWrite(2, LOW);
    }
    else if (req == "on2")
    {
      digitalWrite(4, HIGH);
    }
    else if (req == "off2")
    {
      digitalWrite(4, LOW);
    }
    else
    {
      client.println("requête invalide");
      digitalWrite(5, HIGH);
      delay(300);
      digitalWrite(5, LOW);
    }
    client.stop();
  }

  client.flush();

}
