/*
 * Ce programme montre la création d'un serveur http simple.
 *  le serveur va définir l'état d'une pin digitale suivant les requetes suivantes
 *    http://server_ip/gpio/0 passera le GPIO2 à LOW,
 *    http://server_ip/gpio/1 passera le GPIO2 à  HIGH
 *  L'adresse IP du serveur peut être trouvée sur l'admin du routeur, 
 *  ou via la console série.
 */

#include <ESP8266WiFi.h>

// Les accès pour se connecter au réseau wifi
const char* ssid = "FABLAB";
const char* password = "FABLABFAB";

// On créé un serveur web, en spécifiant le port d'accès en argument
WiFiServer server(80);

void setup() {
  Serial.begin(115200);
  delay(10);

  // Préparons le GPIO2, mais attention ! Les numérotations d'arduino sont différentes (ça doit en faire rire cetrains)
  // Le GPIO2 correspond à D4
  pinMode(2, OUTPUT);
  digitalWrite(2, 0);
  
  // Connectons nous au réseau
  Serial.println();
  Serial.println();
  Serial.print("Connection au réseau: ");
  Serial.println(ssid);
  
  WiFi.begin(ssid, password);
  
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi connecté");
  
  // Puis démarrons le serveur
  server.begin();
  Serial.println("Serveur démarré");

  // Affichage de l'adresse IP
  Serial.println(WiFi.localIP());
}

void loop() {
  // On vérifie qu'un client est connecté
  WiFiClient client = server.available();
  if (!client) {
    return;
  }
  
  // Puis on attends qu'il envoie des données
  Serial.println("Nouveau client");
  while(!client.available()){
    delay(1);
  }
  
  // On lit la première ligne de la requête
  String req = client.readStringUntil('\r');
  Serial.println(req);
  client.flush();
  
  // On analyse cette requête
  int val;
  if (req.indexOf("/gpio/0") != -1)
    val = 0;
  else if (req.indexOf("/gpio/1") != -1)
    val = 1;
  else {
    Serial.println("Requête invalide");
    client.stop();
    return;
  }

  // On adapte l'état de la GPIO2 à la valeur récupérée dans la requête
  digitalWrite(2, val);
  
  client.flush();

  // On prépare la réponse
  String s = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n<!DOCTYPE HTML>\r\n<html>\r\nGPIO is now ";
  s += (val)?"high":"low";
  s += "</html>\n";

  // Puis on l'envoit
  client.print(s);
  delay(1);
  Serial.println("Client déconnecté");

}
