// Reference technique: https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-reference/network/esp_now.html

// Inclure les librairies
#include <esp_now.h>
#include <WiFi.h>

// Stockage de l'adresse MAC du récepteur pour usage ultérieur. Remplacer les 'XX' par les valeur notées plus avant.
//uint8_t MAC_envoi[] = {0xAC, 0x67, 0xB2, 0x37, 0xEC, 0xDC};
uint8_t MAC_envoi[] = {0xAC, 0x67, 0xB2, 0x38, 0x88, 0xC0};

typedef struct struct_message {
  char a[32];
  int b;
  float c;
  bool d;
} struct_message;

struct_message mesDonnees;


// La fonction de rappel qui nous assurera de la bonne livraison du message
void quand_donnees_Envoyees(const uint8_t *mac_addr, esp_now_send_status_t status) {
  Serial.print("\r\nDernier paquet envoyé:\t");
  Serial.println(status == ESP_NOW_SEND_SUCCESS ? "Succès" : "Échec");
}

// callback function that will be executed when data is received
void quand_donnees_Recues(const uint8_t * mac, const uint8_t *mesDonneesRecues, int taille) {
  memcpy(&mesDonnees, mesDonneesRecues, sizeof(mesDonnees));
  Serial.print("Bytes reçus: ");
  Serial.println(taille);
  Serial.print("Char: ");
  Serial.println(mesDonnees.a);
  Serial.print("Int: ");
  Serial.println(mesDonnees.b);
  Serial.print("Float: ");
  Serial.println(mesDonnees.c);
  Serial.print("Bool: ");
  Serial.println(mesDonnees.d);
  Serial.println();
}

// Une variable qui servira à stocker les réglages concernant le récepteur
esp_now_peer_info_t infosRecepteur;

 
void setup() {
  // On initie la comm série à 115200 Bauds
  Serial.begin(115200);
 
  // On démarre le Wifi en mode Station
  WiFi.mode(WIFI_STA);

  // Puis on initialise ESP-NOW
  if (esp_now_init() != ESP_OK) {
    Serial.println("Erreur d'initialisation ESP-NOW");
    return;
  }

  // Si ESP-NOW a correctement démarré, il est temps d'enregistrer la fonction de rappel:
  esp_now_register_send_cb(quand_donnees_Envoyees);
  
  // Tout est prêt pour l'appairage avec notre récepteur:
  memcpy(infosRecepteur.peer_addr, MAC_envoi, 6);
  
  // On définit un canal (0 utilisera automatiquement le même canal que celui utilisé par le wifi)
  infosRecepteur.channel = 0;  

  // On ne chiffre pas les échanges
  infosRecepteur.encrypt = false;
  
  // Appairage        
  if (esp_now_add_peer(&infosRecepteur) != ESP_OK){
    Serial.println("Échec de l'appairage");
    return;
  }
  
  // enregistrement de la fonction de rappel lors de la réception:
  esp_now_register_recv_cb(quand_donnees_Recues);
}
 
void loop() {
  
  // Les valeurs à envoyer
  //strcpy(mesDonnees.a, "ESP N°1");
  strcpy(mesDonnees.a, "ESP N°2");
  mesDonnees.b = random(1,20);
  mesDonnees.c = 1.2;
  mesDonnees.d = false;
  
  // On envoie le message
  esp_err_t resultat = esp_now_send(MAC_envoi, (uint8_t *) &mesDonnees, sizeof(mesDonnees));
   
  if (resultat == ESP_OK) {
    Serial.println("Envoi OK");
  }
  else {
    Serial.println("Erreur envoi");
  }

  // On effectue cette opération toutes les secondes
  delay(2000);
}
