// Inclure les librairies
#include <esp_now.h>
#include <WiFi.h>

// La variable qui sera envoyée au récepteur (nous générerons une valeur aléatoire pour l'exemple)
float maValeurRecue;

// La fonction de rappel qui nous assurera de la bonne livraison du message
void quand_donnees_Recues(const uint8_t * mac, const uint8_t *data_reception, int taille) {
  memcpy(&maValeurRecue, data_reception, sizeof(maValeurRecue));
  Serial.print("Bytes received: ");
  Serial.println(taille);
  Serial.print("valeur reçue: ");
  Serial.println(maValeurRecue);
  Serial.println();
}
 
void setup() {
  // On initie la comm série à 115200 Bauds
  Serial.begin(115200);
 
  // On démarre le Wifi en mode Station
  WiFi.mode(WIFI_STA);

  // Puis on initialise ESP-NOW
  if (esp_now_init() != ESP_OK) {
    Serial.println("Erreur d'initialisation ESP-NOW");
    return;
  }

  // Si ESP-NOW a corectement démarré, il est temps d'enregistrer la fonction de rappel:
  esp_now_register_recv_cb(quand_donnees_Recues);
  
}
 
void loop() {
  
}
