/*
   Based on Neil Kolban example for IDF: https://github.com/nkolban/esp32-snippets/blob/master/cpp_utils/tests/BLE%20Tests/SampleScan.cpp
   Ported to Arduino ESP32 by Evandro Copercini
*/

#include <BLEDevice.h>
#include <BLEUtils.h>
#include <BLEScan.h>
#include <BLEAdvertisedDevice.h>

//LEDS
#define RED_LED 26
#define YLW_LED 25
#define GRN_LED 32

// Seuil de détection
#define RSSI_MIN 70

// Les UUID des périphériques que l'on veut détecter
BLEUUID M5STICK_UUID;
BLEUUID PHONE_UUID;
BLEUUID M5STACK_UUID;

int scanTime = 1; //In seconds
BLEScan* pBLEScan;



class MyAdvertisedDeviceCallbacks: public BLEAdvertisedDeviceCallbacks {
  
    void onResult(BLEAdvertisedDevice advertisedDevice) {
      
      Serial.printf("Advertised Device: %s \n", advertisedDevice.toString().c_str());
      
      if (advertisedDevice.haveRSSI())
      {
        Serial.printf("Rssi: %d \n", (int)advertisedDevice.getRSSI());

        //On allume les LEDS en fonction du seuil de détection et de l'UUID
        
        //M5STICK
        if (advertisedDevice.isAdvertisingService(M5STICK_UUID) && RSSI_MIN>abs(advertisedDevice.getRSSI()))
        {
           digitalWrite(RED_LED, HIGH);
        }
        
        //PHONE
        if (advertisedDevice.isAdvertisingService(PHONE_UUID) && RSSI_MIN>abs(advertisedDevice.getRSSI()))
        {
            digitalWrite(GRN_LED, HIGH);
        }

        //M5STACK
        if (advertisedDevice.isAdvertisingService(M5STACK_UUID) && RSSI_MIN>abs(advertisedDevice.getRSSI()))
        {
            digitalWrite(YLW_LED, HIGH);
        }


        
      }
    }
};

void setup() {
  Serial.begin(115200);

  // 3 LEDS
  pinMode(RED_LED, OUTPUT);
  pinMode(YLW_LED, OUTPUT);
  pinMode(GRN_LED, OUTPUT);

  digitalWrite(RED_LED, LOW);
  digitalWrite(YLW_LED, LOW);
  digitalWrite(GRN_LED, LOW);

  //UUIDs
  M5STICK_UUID = BLEUUID("4fafc201-1fb5-459e-8fcc-c5c9c331914b");
  PHONE_UUID = BLEUUID("0000180f-0000-1000-8000-00805f9b34fb");
  M5STACK_UUID = BLEUUID("869133b4-9c57-4416-86e9-776a95ecfcd1");
  
  Serial.println("Scanning...");

  BLEDevice::init("");
  pBLEScan = BLEDevice::getScan(); //create new scan
  pBLEScan->setAdvertisedDeviceCallbacks(new MyAdvertisedDeviceCallbacks());
  pBLEScan->setActiveScan(true); //active scan uses more power, but get results faster
  pBLEScan->setInterval(100);
  pBLEScan->setWindow(99);  // less or equal setInterval value
}

void loop() {
  //On pense à éteindre les LEDS avant un nouveau scan
  digitalWrite(RED_LED, LOW);
  digitalWrite(YLW_LED, LOW);
  digitalWrite(GRN_LED, LOW);
  // put your main code here, to run repeatedly:
  BLEScanResults foundDevices = pBLEScan->start(scanTime, false);
  Serial.print("Devices found: ");
  Serial.println(foundDevices.getCount());
  Serial.println("Scan done!");
  pBLEScan->clearResults();   // delete results fromBLEScan buffer to release memory
  delay(2000);
}
