/*
   Based on Neil Kolban example for IDF: https://github.com/nkolban/esp32-snippets/blob/master/cpp_utils/tests/BLE%20Tests/SampleScan.cpp
   Ported to Arduino ESP32 by Evandro Copercini
*/
#include <Arduino.h>
#include <U8g2lib.h>

#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
#ifdef U8X8_HAVE_HW_I2C
#include <Wire.h>
#endif

#define full_width 128
#define full_height 64

U8G2_SH1107_64X128_F_4W_HW_SPI u8g2(U8G2_R3, /* cs=*/ 14, /* dc=*/ 27, /* reset=*/ 33);

#include <BLEDevice.h>
#include <BLEUtils.h>
#include <BLEScan.h>
#include <BLEAdvertisedDevice.h>

#define RSSI_MIN 70


 
BLEUUID M5STICK_UUID;

int scanTime = 1; //In seconds
BLEScan* pBLEScan;

boolean tooClose = false;


class MyAdvertisedDeviceCallbacks: public BLEAdvertisedDeviceCallbacks {
  
    void onResult(BLEAdvertisedDevice advertisedDevice) {
      
      Serial.printf("Advertised Device: %s \n", advertisedDevice.toString().c_str());
      
      if (advertisedDevice.haveRSSI())
      {
        Serial.printf("Rssi: %d \n", (int)advertisedDevice.getRSSI());
        
        //M5STICK
        if (advertisedDevice.isAdvertisingService(M5STICK_UUID) && RSSI_MIN>abs(advertisedDevice.getRSSI()))
        {
           tooClose = true;
        }
        
      }
    }
};

void setup() {
  Serial.begin(115200);
  u8g2.begin();
  //UUIDs
  M5STICK_UUID = BLEUUID("4fafc201-1fb5-459e-8fcc-c5c9c331914b");

  Serial.println("Scanning...");

  BLEDevice::init("");
  pBLEScan = BLEDevice::getScan(); //create new scan
  pBLEScan->setAdvertisedDeviceCallbacks(new MyAdvertisedDeviceCallbacks());
  pBLEScan->setActiveScan(true); //active scan uses more power, but get results faster
  pBLEScan->setInterval(100);
  pBLEScan->setWindow(99);  // less or equal setInterval value
}

void loop() {
  tooClose = false;
  // put your main code here, to run repeatedly:
  BLEScanResults foundDevices = pBLEScan->start(scanTime, false);
  Serial.print("Devices found: ");
  Serial.println(foundDevices.getCount());
  Serial.println("Scan done!");
  pBLEScan->clearResults();   // delete results fromBLEScan buffer to release memory
  if (tooClose)
  {
        //FONT
      u8g2.clearBuffer();          // clear the internal memory
      u8g2.setFont(u8g2_font_5x7_tr); // choose a suitable font
      u8g2.drawStr(0,35,"QUELQU'UN APPROCHE!!!!");  // write something to the internal memory
      u8g2.sendBuffer();  
  }else{
              //FONT
      u8g2.clearBuffer();          // clear the internal memory
      u8g2.setFont(u8g2_font_5x7_tr); // choose a suitable font
      u8g2.drawStr(0,35,"Ouf, personne a l'horizon");  // write something to the internal memory
      u8g2.sendBuffer();  
    
  }
  
  delay(1000);
}
