#!/bin/bash

#On dévérouille apt-security pour les mises à jour via l'interface web
sudo apt -y update

#On install wireguard
sudo apt install -y wireguard-dkms

#On récupère le nom du raspberry depuis le domaine saisi à l'install
NAME=$(grep -Po '.*(?=.fablab)' /etc/hostname)

#On récupère le fichier de conf de wireguard depuis le serveur web du fablab et on le copie au bon endroit sous le bon nom
sudo wget http://192.168.1.4/rpi/$NAME.conf -O /etc/wireguard/wg0.conf

#On active le service
sudo systemctl enable wg-quick@wg0

#On règle le pbm des serveurs DNS de google car on parle de vie privée non ?
#Et aussi on évite le warning "Le fichier /etc/resolv.conf doit être un lien symbolique vers /etc/resolvconf/run/resolv.conf... blablabla"
sudo rm /etc/resolv.conf
sudo ln -s /etc/resolvconf/run/resolv.conf /etc/resolv.conf

#Mise à jour complète
sudo apt -y dist-upgrade

#On vire les vieux paquets
sudo apt -y autoremove

#On remplace dans les fichiers /etc/hosts et /etc/avahi/avahi.conf et /etc/yunohost/mdns.yml (yunomdns étant le nouveau service installé durant l'upgrade et qui remplace avahi)
sudo sed -i "s/yunohost/$NAME/g" /etc/hosts /etc/avahi/avahi-daemon.conf /etc/yunohost/mdns.yml

#On active le service yunomdns pour accéder web admin via l'url locale rpi*.local MAIS AUSSI yunohost.local (pratique une fois rentré à la maison)
sudo systemctl enable yunomdns

#On modifie l'ordre de démarrage du service yunomdns pour qu'il démarre après le réseau mais avant le vpn
sudo sed -i 's/network.target/network-online.target/g' /etc/systemd/system/yunomdns.service

#On installe autofs et exfat
sudo apt install -y autofs exfat-utils

#On copie les fichiers de conf d'autofs pour montage auto des clefs dans /mnt/usb
sudo wget http://192.168.1.4/rpi/auto.master -O /etc/auto.master
sudo wget http://192.168.1.4/rpi/auto.usb -O /etc/auto.usb

#On copie la règle udev pour le montage auto des clefs usb
sudo wget http://192.168.1.4/rpi/95-usb.rules -O /etc/udev/rules.d/95-usb.rules

#On redémarre
sudo reboot
