/**
 * Objects
 * by hbarragan. 
 * 
 * Move the cursor across the image to change the speed and positions
 * of the geometry. The class MRect defines a group of lines.
 */
import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;
import ddf.minim.*;
import controlP5.*;


String[] lignes1; //fichier txt
String[] lignes2;
String[] lignes3;
String[] typoActuelle;

ControlP5 cp5;

int taille; //taille d'un carré simple
ArrayList <Lettre> mesLettres = new ArrayList <Lettre>(); //arraylist mesLettres d'un nombre infini de lettres
int placement = 0; //emplacement de la lettre dans le tableau
int nbreColonnes = 5;
int limity;
int deplacementHaut = 0;
int marge = 10;

int dureeSon = 100; // en millisecondes
//String son1 = sketchPath()+ "/data/son1" ; 
String[] nomsdefichiers1; 
//String son2 = sketchPath()+ "/data/son2" ; 
String[] nomsdefichiers2;
//String son3 = sketchPath()+ "/data/son3" ; 
String[] nomsdefichiers3;

Sampler[] samplestypo1;
Sampler[] samplestypo2;
Sampler[] samplestypo3;
Sampler[][] mesSamples;

Minim minim;
AudioOutput out;


void setup()
{
  minim = new Minim(this);
  out   = minim.getLineOut();
  size(1000, 700);
  taille = (width-(marge*(nbreColonnes+1)))/nbreColonnes/7;
  noStroke();
  lignes1 = loadStrings("alphabet1.txt");
  lignes2 = loadStrings("alphabet2.txt");
  lignes3 = loadStrings("alphabet3.txt");
  limity = height-(taille*7+marge)*2;

  typoActuelle = lignes1;
  cp5 = new ControlP5(this);
  ButtonBar b = cp5.addButtonBar("bar")
    .setPosition(10, 10)
    .setSize(width-(marge*2), 20)
    .addItems(split("01 02 03", " "))
    .setColorActive(color(255, 218, 128)) //appuyé
    .setColorValue(color(0, 0, 0)) //typo
    .setColorBackground(color(255, 170, 68)) //case
    .setColorForeground(color(255, 162, 89)) //survol
    ;

  String son1 = sketchPath()+ "/data/son1" ;
  println(son1);
  println("Il y a "+listedesons(son1, mp3Filter).length+" fichiers dans le répertoire.");  // On affiche le nombre de fichiers présents
  println("On liste les fichiers du dossier : "); // On affiche les noms des fichiers sous forme d'un tableau
  nomsdefichiers1 = listedesons(son1, mp3Filter); 
  printArray(nomsdefichiers1); 

  String son2 = sketchPath()+ "/data/son2" ;   
  println("Il y a "+listedesons(son2, mp3Filter).length+" fichiers dans le répertoire.");  // On affiche le nombre de fichiers présents
  println("On liste les fichiers du dossier : "); // On affiche les noms des fichiers sous forme d'un tableau
  nomsdefichiers2 = listedesons(son2, mp3Filter); 
  printArray(nomsdefichiers2); 

  String son3 = sketchPath()+ "/data/son3" ;   
  println("Il y a "+listedesons(son3, mp3Filter).length+" fichiers dans le répertoire.");  // On affiche le nombre de fichiers présents
  println("On liste les fichiers du dossier : "); // On affiche les noms des ficheirs sous forme d'un tableau
  nomsdefichiers3 = listedesons(son3, mp3Filter); 
  printArray(nomsdefichiers3);

  samplestypo1 = new Sampler[nomsdefichiers1.length];
  samplestypo2 = new Sampler[nomsdefichiers2.length];
  samplestypo3 = new Sampler[nomsdefichiers3.length];
  mesSamples = new Sampler[3][];

  for (int i=0; i<nomsdefichiers1.length; i++)
  {
    Sampler sample;
    sample= new Sampler (sketchPath()+"/data/son1/"+nomsdefichiers1[i], 20, minim);
    sample.patch( out );
    samplestypo1[i] = sample;
  }

  for (int i=0; i<nomsdefichiers2.length; i++)
  {
    Sampler sample;
    sample= new Sampler (sketchPath()+"/data/son2/"+nomsdefichiers2[i], 20, minim);
    sample.patch( out );

    samplestypo2[i] = sample;
  }

  for (int i=0; i<nomsdefichiers3.length; i++)
  {
    Sampler sample;
    sample= new Sampler (sketchPath()+"/data/son3/"+nomsdefichiers3[i], 20, minim);
    sample.patch( out );

    samplestypo3[i] = sample;
  }

  mesSamples[0] = samplestypo1;
  mesSamples[1] = samplestypo1;
  mesSamples[2] = samplestypo1;
}

void draw()
{
  background(255);
  for (int i=0; i<mesLettres.size(); i++)
  {
    int decalageX = (7*taille+marge)*(i%nbreColonnes)+marge;
    int decalageY = 40+(7*taille+marge)*(i/nbreColonnes);
    pushMatrix(); //déplacement de l'origine 
    translate(decalageX, decalageY-deplacementHaut); 
    mesLettres.get(i).display(); 
    mesLettres.get(i).play(); 
    popMatrix(); //retour de l'origine à 0
    if (i==mesLettres.size()-1 && i%nbreColonnes == nbreColonnes-1)
    {
      // println("le dernier décalageY est "+ decalageY+ "et la limite est: "+limity );
      if (decalageY>limity)
      {
        deplacementHaut = deplacementHaut +(taille*7);
        limity += (taille*7);
      }
    }
  }
  //  fill(255);
  //  rect(0,0,width,40);
}

void keyPressed()
{
  // On n'écoute que les lettres du clavier
  if ((key >='A' && key <= 'Z') || (key >= 'a' && key <= 'z') || (key == ' '))
  {
    // et on passe la lettre tapée en majuscule
    String maLettreTapee = str(key).toUpperCase();
    mesLettres.add(new Lettre(maLettreTapee, typoActuelle, taille)); //création d'une lettre (en fonction de la touche, du fichier et de sa taille)
    placement = placement+1;
  } 
  if (key == BACKSPACE)
  {
    println ("effacer");
    mesLettres.clear(); 
   deplacementHaut = 0;
     limity = height-(taille*7+marge)*2;
  }
 
}

void bar(int n) {
  //  println("bar clicked, item-value:", n);
  if (0 == n)
  {
    typoActuelle = lignes1;
  }

  if (1 == n)
  {
    typoActuelle = lignes2;
  }

  if (2 == n)
  {
    typoActuelle = lignes3;
  }
}

String[] listedesons(String rep, java.io.FilenameFilter extension) {
  File fichier = new File(rep);
  if (fichier.isDirectory()) {
    String names[] = fichier.list(extension);
    names= sort(names);
    return names;
  } else {
    // If it's not a directory
    return null;
  }
}

java.io.FilenameFilter mp3Filter = new java.io.FilenameFilter()
{
  boolean accept(File dir, String name) 
  {
    return name.toLowerCase().endsWith(".mp3");
  }
};
